package edu.uky.ai.csp;

/**
 * A set of example constraint satisfaction problems to solve.
 * 
 * @author Stephen G. Ware
 */
public class Problems {
	
	/** A Sudoku puzzle which can be solved by constraint propagation alone */
	public static final Sudoku EASY_SUDOKU = new Sudoku(
			"+---+---+---+\n" +
			"|   |9  |872|\n" +
			"|24 |  1|   |\n" +
			"|3  | 5 |6  |\n" +
			"+---+---+---+\n" +
			"|8  | 62| 5 |\n" +
			"|539| 8 |7  |\n" +
			"|   | 3 |14 |\n" +
			"+---+---+---+\n" +
			"|621|   |  3|\n" +
			"| 7 |8  |4  |\n" +
			"|  5| 1 | 9 |\n" +
			"+---+---+---+"
		);
	
	/** A Sudoku in which some but not all values can be discovered by constraint propagation */
	public static final Sudoku MEDIUM_SUDOKU = new Sudoku(
			"+---+---+---+\n" +
			"| 4 | 6 |  2|\n" +
			"| 1 |527|   |\n" +
			"|   |   |   |\n" +
			"+---+---+---+\n" +
			"|  9|4  |  3|\n" +
			"|  8|   | 9 |\n" +
			"|2 6| 8 | 7 |\n" +
			"+---+---+---+\n" +
			"|3  |2  |5  |\n" +
			"|   |   |   |\n" +
			"|   |978|1  |\n" +
			"+---+---+---+"
		);
	
	/** A Sudoku in which no values can be discovered by constraint propagation (called "the hardest Sudoku puzzle in the world" by some) */
	public static final Sudoku HARD_SUDOKU = new Sudoku(
			"+---+---+---+\n" +
			"|8  |   |   |\n" +
			"|  3|6  |   |\n" +
			"| 7 | 9 |2  |\n" +
			"+---+---+---+\n" +
			"| 5 |  7|   |\n" +
			"|   | 45|7  |\n" +
			"|   |1  | 3 |\n" +
			"+---+---+---+\n" +
			"|  1|   | 68|\n" +
			"|  8|5  | 1 |\n" +
			"| 9 |   |4  |\n" +
			"+---+---+---+"
		);
	
	/** A map of the regions of Australia */
	public static final MapColoring AUSTRALIA_MAP_COLORING = new MapColoring(
			"WA,NT,SA\n" +
			"NT,WA,SA,Q\n" +
			"SA,WA,NT,Q,NSW,V\n" +
			"Q,NT,SA,NSW\n" +
			"NSW,SA,Q,V\n" +
			"V,SA,NSW\n" +
			"T"
		);
	
	/** A map of the states in the USA (including DC) */
	public static final MapColoring USA_MAP_COLORING = new MapColoring(
			"AK\n" +
			"AL,MS,TN,GA,FL\n" +
			"AR,MO,TN,MS,LA,TX,OK\n" +
			"AZ,CA,NV,UT,CO,NM\n" +
			"CA,OR,NV,AZ\n" +
			"CO,WY,NE,KS,OK,NM,AZ,UT\n" +
			"CT,NY,MA,RI\n" +
			"DC,MD,VA\n" +
			"DE,MD,PA,NJ\n" +
			"FL,AL,GA\n" +
			"GA,FL,AL,TN,NC,SC\n" +
			"HI\n" +
			"IA,MN,WI,IL,MO,NE,SD\n" +
			"ID,MT,WY,UT,NV,OR,WA\n" +
			"IL,IN,KY,MO,IA,WI\n" +
			"IN,MI,OH,KY,IL\n" +
			"KS,NE,MO,OK,CO\n" +
			"KY,IN,OH,WV,VA,TN,MO,IL\n" +
			"LA,TX,AR,MS\n" +
			"MA,RI,CT,NY,NH,VT\n" +
			"MD,VA,WV,PA,DC,DE\n" +
			"ME,NH\n" +
			"MI,WI,IN,OH\n" +
			"MN,WI,IA,SD,ND\n" +
			"MO,IA,IL,KY,TN,AR,OK,KS,NE\n" +
			"MS,LA,AR,TN,AL\n" +
			"MT,ND,SD,WY,ID\n" +
			"NC,VA,TN,GA,SC\n" +
			"ND,MN,SD,MT\n" +
			"NE,SD,IA,MO,KS,CO,WY\n" +
			"NH,VT,ME,MA\n" +
			"NJ,DE,PA,NY\n" +
			"NM,AZ,UT,CO,OK,TX\n" +
			"NV,ID,UT,AZ,CA,OR\n" +
			"NY,NJ,PA,VT,MA,CT\n" +
			"OH,PA,WV,KY,IN,MI\n" +
			"OK,KS,MO,AR,TX,NM,CO\n" +
			"OR,CA,NV,ID,WA\n" +
			"PA,NY,NJ,DE,MD,WV,OH\n" +
			"RI,CT,MA\n" +
			"SC,GA,NC\n" +
			"SD,ND,MN,IA,NE,WY,MT\n" +
			"TN,KY,VA,NC,GA,AL,MS,AR,MO\n" +
			"TX,NM,OK,AR,LA\n" +
			"UT,ID,WY,CO,NM,AZ,NV\n" +
			"VA,NC,TN,KY,WV,MD,DC\n" +
			"VT,NY,NH,MA\n" +
			"WA,ID,OR\n" +
			"WI,MI,MN,IA,IL\n" +
			"WV,OH,PA,MD,VA,KY\n" +
			"WY,MT,SD,NE,CO,UT,ID"
		);
}
